#include <bits/stdc++.h>
using namespace std;

struct Tacka {
    long long x;
    long long y;
};

long long krst(const Tacka &O, const Tacka &A, const Tacka &B) {
    long long r1 = (A.x - O.x) * (B.y - O.y);
    long long r2 = (A.y - O.y) * (B.x - O.x);
    return r1-r2;
}

long long povMnogougla(const vector<Tacka>& tacke) {
    long long povrsina = 0;
    int n = tacke.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        povrsina += (tacke[i].x * tacke[j].y) - (tacke[j].x * tacke[i].y);
    }
    return abs(povrsina) / 2;
}

bool F(const Tacka &a, const Tacka &b){
    return a.x < b.x || (a.x == b.x && a.y < b.y);
}

vector<Tacka> konvOmotac(vector<Tacka>& tacke) {
    int n = tacke.size();
    int k = 0;
    vector<Tacka> omotac(2*n);
    sort(tacke.begin(), tacke.end(), F);
    for(int i = 0; i < n; i++){
        while (k >= 2 && krst(omotac[k-2], omotac[k-1], tacke[i]) <= 0){
            k--;
        }
        omotac[k] = tacke[i];
        k++;
    }
    int t = k+1;
    for(int i = n-2; i >= 0; i--){
        while(k >= t && krst(omotac[k-2], omotac[k-1], tacke[i]) <= 0){
            k--;
        }
        omotac[k] = tacke[i];
        k++;
    }
    omotac.resize(k-1);
    return omotac;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int n;
    cin >> n;
    vector<Tacka> tacke(n);
    for(int i = 0; i < n; i++){
        cin >> tacke[i].x >> tacke[i].y;
    }
    vector<Tacka> omotac = konvOmotac(tacke);
    long long minPovrsina = povMnogougla(omotac);

    for(int i = 0; i < omotac.size(); i++){
        vector<Tacka> trTacke;
        for(int j = 0; j < n; j++){
            if (tacke[j].x != omotac[i].x || tacke[j].y != omotac[i].y) {
                trTacke.push_back(tacke[j]);
            }
        }
        vector<Tacka> trOmotac = konvOmotac(trTacke);
        minPovrsina = min(minPovrsina, povMnogougla(trOmotac));
    }

    cout << minPovrsina << "\n";
    return 0;
}